/**
  ******************************************************************************
  * @file    py32f410_hal_gpio_ex.h
  * @author  MCU Application Team
  * @brief   Header file of GPIO HAL Extended module.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2016 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __PY32F410_HAL_GPIO_EX_H
#define __PY32F410_HAL_GPIO_EX_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "py32f410_hal_def.h"

/** @addtogroup PY32F410_HAL_Driver
  * @{
  */

/** @defgroup GPIOEx GPIOEx
  * @brief GPIO Extended HAL module driver
  * @{
  */

/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
/** @defgroup GPIOEx_Exported_Constants GPIOEx Exported Constants
  * @{
  */

/** @defgroup GPIOEx_Alternate_function_selection GPIOEx Alternate function selection
  * @{
  */

/*------------------------- PY32F410 ------------------------*/
/**
  * @brief   AF 0 selection
  */
#define GPIO_AF0_MCO           ((uint8_t)0x00)  /*!< MCO Alternate Function mapping */
#define GPIO_AF0_SWJ           ((uint8_t)0x00)  /*!< SWJ (SWD/JTAG) Alternate Function mapping */
#define GPIO_AF0_TRACE         ((uint8_t)0x00)  /*!< TRACE Alternate Function mapping */

/**
* @brief   AF 1 selection
*/
#define GPIO_AF1_I2C2          ((uint8_t)0x01)  /*!< I2C2 Alternate Function mapping */
#define GPIO_AF1_IR            ((uint8_t)0x01)  /*!< IR OUT Alternate Function mapping */
#define GPIO_AF1_SPI1          ((uint8_t)0x01)  /*!< SPI1 Alternate Function mapping */
#define GPIO_AF1_I2S1          ((uint8_t)0x01)  /*!< I2S1 Alternate Function mapping */
#define GPIO_AF1_SPI2          ((uint8_t)0x01)  /*!< SPI2 Alternate Function mapping */
#define GPIO_AF1_I2S2          ((uint8_t)0x01)  /*!< I2S2 Alternate Function mapping */
#define GPIO_AF1_TIM15         ((uint8_t)0x01)  /*!< TIM15 Alternate Function mapping */
#define GPIO_AF1_TIM17         ((uint8_t)0x01)  /*!< TIM17 Alternate Function mapping */
#define GPIO_AF1_TIM3          ((uint8_t)0x01)  /*!< TIM3 Alternate Function mapping */

/**
* @brief   AF 2 selection
*/
#define GPIO_AF2_I2C1          ((uint8_t)0x02)  /*!< I2C1 Alternate Function mapping */
#define GPIO_AF2_I2C2          ((uint8_t)0x02)  /*!< I2C2 Alternate Function mapping */
#define GPIO_AF2_IR            ((uint8_t)0x02)  /*!< IR OUT Alternate Function mapping */
#define GPIO_AF2_SPI1          ((uint8_t)0x02)  /*!< SPI1 Alternate Function mapping */
#define GPIO_AF2_SPI2          ((uint8_t)0x02)  /*!< SPI2 Alternate Function mapping */
#define GPIO_AF2_I2S2          ((uint8_t)0x02)  /*!< I2S2 Alternate Function mapping */
#define GPIO_AF2_TIM15         ((uint8_t)0x02)  /*!< TIM15 Alternate Function mapping */
#define GPIO_AF2_TIM2          ((uint8_t)0x02)  /*!< TIM2 Alternate Function mapping */
#define GPIO_AF2_TIM3          ((uint8_t)0x02)  /*!< TIM3 Alternate Function mapping */

/**
* @brief   AF 3 selection
*/
#define GPIO_AF3_TIM1          ((uint8_t)0x03)  /*!< TIM1 Alternate Function mapping */
#define GPIO_AF3_TIM16         ((uint8_t)0x03)  /*!< TIM16 Alternate Function mapping */
#define GPIO_AF3_TIM17         ((uint8_t)0x03)  /*!< TIM17 Alternate Function mapping */
#define GPIO_AF3_TIM2          ((uint8_t)0x03)  /*!< TIM2 Alternate Function mapping */

/**
* @brief   AF 4 selection
*/
#define GPIO_AF4_I2C1          ((uint8_t)0x04)  /*!< I2C1 Alternate Function mapping */
#define GPIO_AF4_I2C2          ((uint8_t)0x04)  /*!< I2C2 Alternate Function mapping */
#define GPIO_AF4_I2S2          ((uint8_t)0x04)  /*!< I2S2 Alternate Function mapping */
#define GPIO_AF4_TIM15         ((uint8_t)0x04)  /*!< TIM15 Alternate Function mapping */

/**
* @brief   AF 5 selection
*/
#define GPIO_AF5_COMP1         ((uint8_t)0x05)  /*!< COMP1 Alternate Function mapping */
#define GPIO_AF5_COMP2         ((uint8_t)0x05)  /*!< COMP2 Alternate Function mapping */
#define GPIO_AF5_OPA2_COMP     ((uint8_t)0x05)  /*!< OPA2_COMP Alternate Function mapping */
#define GPIO_AF5_I2C1          ((uint8_t)0x05)  /*!< I2C1 Alternate Function mapping */
#define GPIO_AF5_TIM4          ((uint8_t)0x05)  /*!< TIM4 Alternate Function mapping */

/**
* @brief   AF 6 selection
*/
#define GPIO_AF6_I2C1          ((uint8_t)0x06)  /*!< I2C1 Alternate Function mapping */
#define GPIO_AF6_I2C2          ((uint8_t)0x06)  /*!< I2C2 Alternate Function mapping */
#define GPIO_AF6_I2S1          ((uint8_t)0x06)  /*!< I2S1 Alternate Function mapping */
#define GPIO_AF6_I2S2          ((uint8_t)0x06)  /*!< I2S2 Alternate Function mapping */
#define GPIO_AF6_SPI1          ((uint8_t)0x06)  /*!< SPI1 Alternate Function mapping */
#define GPIO_AF6_SPI2          ((uint8_t)0x06)  /*!< SPI2 Alternate Function mapping */
#define GPIO_AF6_TIM1          ((uint8_t)0x06)  /*!< TIM1 Alternate Function mapping */
#define GPIO_AF6_TIM15         ((uint8_t)0x06)  /*!< TIM15 Alternate Function mapping */
#define GPIO_AF6_TIM16         ((uint8_t)0x06)  /*!< TIM16 Alternate Function mapping */
#define GPIO_AF6_TIM17         ((uint8_t)0x06)  /*!< TIM17 Alternate Function mapping */

/**
  * @brief   AF 7 selection
  */
#define GPIO_AF7_I2C1          ((uint8_t)0x07)  /*!< I2C1 Alternate Function mapping */
#define GPIO_AF7_I2C2          ((uint8_t)0x07)  /*!< I2C2 Alternate Function mapping */
#define GPIO_AF7_I2S1          ((uint8_t)0x07)  /*!< I2S1 Alternate Function mapping */
#define GPIO_AF7_I2S2          ((uint8_t)0x07)  /*!< I2S2 Alternate Function mapping */
#define GPIO_AF7_SPI2          ((uint8_t)0x07)  /*!< SPI2 Alternate Function mapping */

/**
  * @brief   AF 8 selection
  */
#define GPIO_AF8_I2C1          ((uint8_t)0x08U)  /*!< I2C1 Alternate Function mapping */
#define GPIO_AF8_I2C2          ((uint8_t)0x08U)  /*!< I2C2 Alternate Function mapping */
#define GPIO_AF8_SPI1          ((uint8_t)0x08U)  /*!< SPI1 Alternate Function mapping */
#define GPIO_AF8_I2S1          ((uint8_t)0x08U)  /*!< I2S1 Alternate Function mapping */
#define GPIO_AF8_TIM4          ((uint8_t)0x08U)  /*!< TIM4 Alternate Function mapping */

/**
  * @brief   AF 9 selection
  */
#define GPIO_AF9_LPTIM1        ((uint8_t)0x09U)  /*!< LPTIM1 Alternate Function mapping */

/**
  * @brief   AF 10 selection
  */
#define GPIO_AF10_PWM1         ((uint8_t)0x0A)  /*!< PWM1 Alternate Function mapping */

/**
  * @brief   AF 11 selection
  */
#define GPIO_AF11_PWM2         ((uint8_t)0x0B)  /*!< PWM2 Alternate Function mapping */

/**
  * @brief   AF 12 selection
  */
#define GPIO_AF12_PWM3         ((uint8_t)0x0C)  /*!< PWM3 Alternate Function mapping */  
#define GPIO_AF12_PWM4         ((uint8_t)0x0C)  /*!< PWM4 Alternate Function mapping */ 

/**
  * @brief   AF 13 selection
  */
#define GPIO_AF13_UART1        ((uint8_t)0x0D)  /*!< UART1 Alternate Function mapping */
#define GPIO_AF13_UART2        ((uint8_t)0x0D)  /*!< UART2 Alternate Function mapping */
#define GPIO_AF13_USART1       ((uint8_t)0x0D)  /*!< USART1 Alternate Function mapping */

/**
  * @brief   AF 14 selection
  */
#define GPIO_AF14_LPUART1      ((uint8_t)0x0E)  /*!< LPUART1 Alternate Function mapping */
#define GPIO_AF14_USART1       ((uint8_t)0x0E)  /*!< USART1 Alternate Function mapping */

/**
  * @brief   AF 15 selection
  */
#define GPIO_AF15_EVENT        ((uint8_t)0x0F)  /*!< EVENT Alternate Function mapping */
#define IS_GPIO_AF(AF)         ((AF) <= (uint8_t)0x0f)
/**
  * @}
  */

/**
  * @}
  */

/* Exported macro ------------------------------------------------------------*/
/** @defgroup GPIOEx_Exported_Macros GPIOEx Exported Macros
  * @{
  */

/** @defgroup GPIOEx_Get_Port_Index GPIOEx Get Port Index
  * @{
  */
#define GPIO_GET_INDEX(__GPIOx__)    (((__GPIOx__) == (GPIOA))? 0UL :\
                                      ((__GPIOx__) == (GPIOB))? 1UL :\
                                      ((__GPIOx__) == (GPIOC))? 2UL : 3U)

/**
  * @}
  */

/**
  * @}
  */

/* Exported functions --------------------------------------------------------*/
/**
  * @}
  */

/**
  * @}
  */

#ifdef __cplusplus
}
#endif

#endif /* __PY32F410_HAL_GPIO_EX_H */

/************************ (C) COPYRIGHT Puya *****END OF FILE******************/
